:
UTIL_DIR=`dirname ${0}`
. ${UTIL_DIR}/helpers.sh
mkdir -p /mnt/onecontext
dmesg |grep -q cd0 && mount_cd9660 /dev/cd0a /mnt/onecontext || exit 1
CTX=/mnt/onecontext/context.sh

cat $CTX

# tie available PHY to requestesd NIC contexts
echo 'PHY emulations'
get_ifs
echo 'contexts requested'
ETH_CTX=`awk -F_ '/^ETH/ { eths[$1]++ } END { for (eth in eths) { print eth } }' /mnt/onecontext/context.sh`
echo $ETH_CTX
. ${CTX}

add_hif() {
  echo "$@" >> /etc/hostname.$_hif
}
create_network() {
 _ctx=$1
 _hif=$2
 echo "$_ctx info for creating $_hif"

 echo "description $_hif for context $_ctx" > /etc/hostname.$_hif
 chmod 640 /etc/hostname.$_hif
 echo up >> /etc/hostname.$_hif
 eval "ipv4=\$${_ctx}_IP"
 eval "ipv4_mask=\$${_ctx}_MASK"
 eval "ipv6=\$${_ctx}_IP6"
 eval "ipv6_prefix=\$${_ctx}_IP6_PREFIX_LENGTH"
 eval "mtu=\$${_ctx}_MTU"
 [[ -z "$ipv6_prefix" ]] && ipv6_prefix="64"
 [[ -n "$ipv4" ]] && add_hif inet $ipv4 netmask $ipv4_mask
 [[ -n "$ipv6" ]] && add_hif inet6 ${ipv6}/$ipv6_prefix
 [[ -n "$mtu" ]] && add_hif mtu $mtu

 # default routing, v4/v6 can coexist
 eval "gw=\$${_ctx}_GATEWAY"
 eval "gw6=\$${_ctx}_GATEWAY6"
 [[ -n "$gw" ]] && echo "$gw" >> /etc/mygate
 [[ -n "$gw6" ]] && echo "$gw6" >> /etc/mygate

 #nameservers
 echo "lookup file bind" >> /etc/resolv.conf
 eval "dns=\$${_ctx}_DNS"
 [[ -n "$dns" ]] && { for ns in $dns; do
      echo "nameserver $ns" >> /etc/resolv.conf; done }
 # cannot do in vagrant # sh /etc/netstart $_hif
 [[ -n "$SET_HOSTNAME" ]] && {
   echo "$SET_HOSTNAME" >> /etc/myname
   hostname $SET_HOSTNAME
 }
}

echo 'mapping context to PHY'
: > /etc/resolv.conf
: > /etc/mygate
for _if in ${ETH_CTX}; do
 _eth_mac=`awk -F\' '/^'$_if'_MAC=/ { print tolower($2) }' < ${CTX}`
 for _phy in `get_ifs`; do
  ifconfig $_phy | grep -q "lladdr $_eth_mac" && create_network ${_if} ${_phy}
 done
done


umount /mnt/onecontext 2> /dev/null
