#!/bin/bash
sleepdelay="5"                # Delay between commands
gameaddr="[::]:5002"          # Game server address
user="sxiii-$(date +%HH%MM)"  # User to register
network="2a0a:e5c0:101::/64"  # Network to register

cmd="http $gameaddr"
echo -e "Getting information about the game:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http POST $gameaddr/register user=$user"
echo -e "Registering a new user called $user:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http POST $gameaddr/register user=$user"
echo -e "Trying to register with the same user again:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http $gameaddr/challenge"
echo -e "Looking which challenges are available:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http $gameaddr/challenge/RegisterNet"
echo -e "Reading challenge #1 description:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http POST $gameaddr/challenge/RegisterNet user=$user network=$network"
echo -e "Registering network (challenge 1):\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http POST $gameaddr/challenge/RegisterNet user=$user network=$network"
echo -e "Trying to register network again:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http POST $gameaddr/points user=$user"
echo -e "Getting points for our player:\n $ $cmd"
sleep $sleepdelay && eval "$cmd"

cmd="http POST $gameaddr/challenge/IPv6Address user=sxiii"
echo -e "Checking if IP is pingable (challenge 2):\n $ $cmd"
sleep $sleepdelay && eval "$cmd"
sleep $sleepdelay
toilet --rainbow -t "Done! Thank you :)"

#1) Information about the game: ("curl ip/index")
#2) Registration of the new user with his IP and date: ("curl -X POST -d user=sxiii ip/register")
#3) Checking if user registered, it returns user IP (re-run previous command again)
#4) Challenges listing ("curl ip/challenge")
#5) RegisterNet challenge ("curl -X POST -d user=sxiii -d 'network=2a0a:e5c0:101::/64' ip/challenge/RegisterNet")
#6) Checking if challenge already done; it returns error (re-run prev. command)
#7) Getting points for user: ``` curl -X POST -d user=sxiii ip/points ```
#8) Challenge IPv6Address (checking if IP is pingable): ``` curl -X POST -d user=sxiii ip/challenge/IPv6Address ```
