jibri-server (new):
````
modprobe snd-aloop
echo "snd-aloop" >> /etc/modules
apt update
apt -y install ffmpeg curl unzip software-properties-common

wget -qO - https://dl-ssl.google.com/linux/linux_signing_key.pub | apt-key add -
echo "deb [arch=amd64] http://dl.google.com/linux/chrome/deb/ stable main" > /etc/apt/sources.list.d/google-chrome.list
apt update
apt -y install google-chrome-stable 

CHROME_DRIVER_VERSION=`curl -sS chromedriver.storage.googleapis.com/LATEST_RELEASE`
wget -N http://chromedriver.storage.googleapis.com/$CHROME_DRIVER_VERSION/chromedriver_linux64.zip -P ~/
unzip ~/chromedriver_linux64.zip -d ~/
rm ~/chromedriver_linux64.zip
mv -f ~/chromedriver /usr/local/bin/chromedriver
chmod 0755 /usr/local/bin/chromedriver

mkdir -p /etc/opt/chrome/policies/managed
echo '{ "CommandLineFlagSecurityWarningsEnabled": false }' >>/etc/opt/chrome/policies/managed/managed_policies.json

# might be skipped if this is on the same host that has jitsi already
echo 'deb https://download.jitsi.org stable/' >> /etc/apt/sources.list.d/jitsi-stable.list
wget -qO - https://download.jitsi.org/jitsi-key.gpg.key | apt-key add -
apt update 

apt -y install jibri # this will as for a keyboard layout.. just default
usermod -aG adm,audio,video,plugdev jibri 

mkdir /talkrec
chown jibri:jitsi /talkrec

# using the new config file format already, no need to migrate later
cat <<EOH > /etc/jitsi/jibri/jibri.conf
jibri {
    recording {
        recordings-directory = "/talkrec"
        finalize-script = ""
    }
    api {
        xmpp {
            environments = [
                {
                    name = "talk-prod"
                    xmpp-server-hosts = [ "talk.ungleich.ch" ]
                    xmpp-domain = "talk.ungleich.ch"

                    control-muc {
                        domain = "internal.auth.talk.ungleich.ch"
                        room-name = "JibriBrewery"
                        nickname = "jibri1"
                    }

                    control-login {
                        domain = "auth.talk.ungleich.ch"
                        username = "jibri"
                        password = "jibriPASS123"
                    }

                    call-login {
                        domain = "recorder.talk.ungleich.ch"
                        username = "recorder"
                        password = "recPASS123"
                    }

                    strip-from-room-domain = "talk.ungleich.ch"
                    usage-timeout = 8 hour

                    trust-all-xmpp-certs = true
                }
            ]
        }
    }
}
EOH

systemctl enable --now jibri
````

And now for nginx to offer the generated recordings for downloads
````
apt -y install nginx
openssl req -newkey rsa:4096 -x509 -sha256 -days 3650 -nodes -out /etc/ssl/mycert.pem -keyout /etc/ssl/private/mycert.key
cat <<EOH >/etc/nginx/nginx.conf
user jibri;
worker_processes auto;
pid /run/nginx.pid;
include /etc/nginx/modules-enabled/*.conf;

events {
        worker_connections 768;
        # multi_accept on;
}

http {
        sendfile on;
        tcp_nopush on;
        tcp_nodelay on;
        keepalive_timeout 65;
        types_hash_max_size 2048;
        # server_tokens off;

        # server_names_hash_bucket_size 64;
        # server_name_in_redirect off;

        include /etc/nginx/mime.types;
        default_type application/octet-stream;

        access_log /var/log/nginx/access.log;
        error_log /var/log/nginx/error.log;

    server {
        listen [::]:80 default_server;

        return 301 https://$host$request_uri;
    }

    server {
        listen [::]:443 ssl http2;

        ssl_certificate /etc/ssl/mycert.pem;
        ssl_certificate_key /etc/ssl/private/mycert.key;
        ssl_session_timeout 1d;
        ssl_session_cache shared:MozSSL:10m;  # about 40000 sessions
        ssl_session_tickets off;
        ssl_dhparam /etc/ssl/private/dhparam;

        ssl_protocols TLSv1.2 TLSv1.3;
        ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305
:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384;
        ssl_prefer_server_ciphers off;

        root /talkrec;
        location / { autoindex on; }
    }
}
EOH
service nginx restart
````

